//+------------------------------------------------------------------+
//|                                         Correlation Charting.mq4 |
//|                                Copyright  2006, Nicholas Barker |
//|                                                  nick@barker.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Nicholas Barker"
#property link      "nick@barker.net"
//#include <WinUser32.mqh>
#property indicator_separate_window
#property indicator_buffers 5
//#property indicator_color1 DarkOrchid


extern string     symbol1       ="";
extern string     s1correlation    ="+";
extern color     s1color  =DarkOrchid;

extern double     s1adjust_percent    =100;
extern string     s2       ="";
extern string     s2cor    ="+";
 double     s2adj    =100;
extern string     s3       ="";
extern string     s3cor    ="+";
double     s3adj    =100;
extern string     s4       ="";
extern string     s4cor    ="+";
double     s4adj    =100;
string s[4];
string cor[4];
double adj[4];
bool hasrun=false;

//---- buffers
double E1[];
double E2[];
double E3[];
double E4[];
double E5[];
double E1b[];

int bar;
double base;
double base2[4];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
  
   
//----
 if(StringFind(Symbol(),"m",0)>0){
      symbol1=symbol1+"m";
      s2=s2+"m";
      s3=s3+"m";
      s4=s4+"m";
   }
   s[0]=symbol1;
   s[1]=s2;
   s[2]=s3;
   s[3]=s4;
   cor[0]=s1correlation;
   cor[1]=s2cor;
   cor[2]=s3cor;
   cor[3]=s4cor;
   adj[0]=s1adjust_percent;
   adj[1]=s2adj;
   adj[2]=s3adj;
   adj[3]=s4adj;

   SetIndexStyle(0,DRAW_LINE,0,2,s1color);
   SetIndexBuffer(0,E1);
   SetIndexStyle(1,DRAW_LINE,0,2,Crimson);
   SetIndexBuffer(1,E2);
   SetIndexStyle(2,DRAW_LINE,0,2,Purple);
   SetIndexBuffer(2,E3);
   SetIndexStyle(3,DRAW_LINE,0,2,Gold);
   SetIndexBuffer(3,E4);
   SetIndexStyle(4,DRAW_LINE,0,2,Red);
   SetIndexBuffer(4,E5);
   
  
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   GlobalVariableSet(Symbol()+"CCIND",GlobalVariableGet(Symbol()+"CCIND")-1);
   ObjectsDeleteAll();
   Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   
   if(hasrun){
      run();
   }else{
      runonce();
      hasrun=true;
   }
   
   
//----
   return(0);
}
//+------------------------------------------------------------------+

int runonce(){
   bar= WindowFirstVisibleBar();
   int c;
   base= Close[bar-1];
   //Comment(base,"  ",bar-1);
   //double base2[4];//=iClose(Correlation_Pair,0,bar-1);
   for(int y=0;y<4;y++)base2[y]=iClose(s[y],0,bar-1);
   for(y=0;y<4;y++){
      if(StringLen(s[y])>2){
         c++;
      }
   }
   int i;double change,hh;
   
   if(StringLen(s[0])>2){
      for(i=bar-1;i>=0;i--){
         
         datetime time = iTime(Symbol(),0,i);
         int ss = iBarShift(s[0],0,time,false);
         
         change = base2[0] - iClose(s[0],0,ss);
         change = change / MarketInfo(s[0],MODE_POINT);
         change = change * (adj[0]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E1[i]=Close[i]-hh;
       
               
      }
   }
   double hi,lo;int hibar,lobar=99999;
   if(c<=1){
      
      for(i=bar-1;i>=0;i--){
         if(E1[i]>hi){
            hi=E1[i];
            hibar=i;
         }
         if(E1[i]<lo){
            lo=E1[i];
            lobar=i;
         }
      }
      SetLevelValue(0,(hi+lo)/2);
      SetLevelStyle(DRAW_LINE,0,Red);
      
   }
         
   if(StringLen(s[1])>2){
      for(i=bar-1;i>=0;i--){
         change = base2[1] - iClose(s[1],0,i);
         change = change / MarketInfo(s[1],MODE_POINT);
         change = change * (adj[1]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E2[i]=Close[i]-hh;
      }
   }
   if(StringLen(s[2])>2){
      for(i=bar-1;i>=0;i--){
         change = base2[2] - iClose(s[2],0,i);
         change = change / MarketInfo(s[2],MODE_POINT);
         change = change * (adj[2]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E3[i]=Close[i]-hh;
      }
   }
   if(StringLen(s[3])>2){
      for(i=bar-1;i>=0;i--){
         change = base2[3] - iClose(s[3],0,i);
         change = change / MarketInfo(s[3],MODE_POINT);
         change = change * (adj[3]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E4[i]=Close[i]-hh;
      }
   }
   return(0);
}
///////////////////////////////////////////////////////////////////////
int run(){
  
   int i=0;double change,hh;
   if(StringLen(s[0])>2){
     // for(i=bar-1;i>=0;i--){
         change = base2[0] - iClose(s[0],0,i);
         change = change / MarketInfo(s[0],MODE_POINT);
         change = change * (adj[0]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E1[i]=Close[i]-hh;
     // }
   }
   
         
   if(StringLen(s[1])>2){
     // for(i=bar-1;i>=0;i--){
         change = base2[1] - iClose(s[1],0,i);
         change = change / MarketInfo(s[1],MODE_POINT);
         change = change * (adj[1]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E2[i]=Close[i]-hh;
      //}
   }
   if(StringLen(s[2])>2){
     // for(i=bar-1;i>=0;i--){
         change = base2[2] - iClose(s[2],0,i);
         change = change / MarketInfo(s[2],MODE_POINT);
         change = change * (adj[2]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E3[i]=Close[i]-hh;
     // }
   }
   if(StringLen(s[3])>2){
     // for(i=bar-1;i>=0;i--){
         change = base2[3] - iClose(s[3],0,i);
         change = change / MarketInfo(s[3],MODE_POINT);
         change = change * (adj[3]/100);
         if(cor[0]=="+"){
            hh=base-change*Point;
         }else {
            hh=base+change*Point;
         }
         E4[i]=Close[i]-hh;
     // }
   }
   return(0);
}

